const { ethers } = require("hardhat");

async function main() {
  console.log("Deploying Obitix smart contracts...");

  // Get the contract factory
  const ObitixCustody = await ethers.getContractFactory("ObitixCustody");
  
  console.log("Deploying ObitixCustody contract...");
  
  // Deploy the contract
  const obitixCustody = await ObitixCustody.deploy();
  
  // Wait for deployment to finish
  await obitixCustody.waitForDeployment();
  
  const address = await obitixCustody.getAddress();
  
  console.log("ObitixCustody deployed to:", address);
  
  // Verify the deployment
  console.log("Verifying contract deployment...");
  
  try {
    await hre.run("verify:verify", {
      address: address,
      constructorArguments: [],
    });
    console.log("Contract verified successfully!");
  } catch (error) {
    console.log("Verification failed:", error.message);
  }
  
  // Save deployment info
  const deploymentInfo = {
    network: hre.network.name,
    contract: "ObitixCustody",
    address: address,
    deployer: (await ethers.getSigners())[0].address,
    timestamp: new Date().toISOString(),
    blockNumber: await ethers.provider.getBlockNumber()
  };
  
  console.log("Deployment completed successfully!");
  console.log("Deployment info:", JSON.stringify(deploymentInfo, null, 2));
  
  // Save to file for backend configuration
  const fs = require('fs');
  const path = require('path');
  
  const deploymentPath = path.join(__dirname, '../deployment.json');
  fs.writeFileSync(deploymentPath, JSON.stringify(deploymentInfo, null, 2));
  
  console.log(`Deployment info saved to: ${deploymentPath}`);
  
  return deploymentInfo;
}

main()
  .then(() => process.exit(0))
  .catch((error) => {
    console.error("Deployment failed:", error);
    process.exit(1);
  });
